<?php
/* --------------------------------------------------------------
  RepositoryInterface.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Repository;

use Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto\EanCollectionDto;
use Gambio\Shop\Product\ValueObjects\ProductId;

/**
 * Interface RepositoryInterface
 * @package Gambio\Shop\Attributes\SellingUnitEan\Repository
 */
interface RepositoryInterface
{
    /**
     * @param array     $optionIds
     * @param ProductId $productId
     *
     * @return EanCollectionDto
     */
    public function getEanValuesByProduct(array $optionIds, ProductId $productId) : EanCollectionDto;
}